﻿#ifndef SKINNEDDATA_H
#define SKINNEDDATA_H

#include "d3dUtil.h"
#include <map>

///<summary>
/// Keyframe określa przekształcenie kości w danym momencie.
///</summary>
struct Keyframe
{
	Keyframe();
	~Keyframe();

    float TimePos;
	XMFLOAT3 Translation;
	XMFLOAT3 Scale;
	XMFLOAT4 RotationQuat;
};

///<summary>
/// BoneAnimation określa lista klatek kluczowych. W przypadku wartości
/// czasu pomiędzy dwiema klatkami kluczowymi dokonujemy interpolacji
/// między nimi.  
///
/// Zakładamy, że animacja zawsze posiada przynajmniej dwie klatki kluczowe.
///</summary>
struct BoneAnimation
{
	float GetStartTime()const;
	float GetEndTime()const;

    void Interpolate(float t, XMFLOAT4X4& M)const;

	std::vector<Keyframe> Keyframes; 	

};

///<summary>
/// Przykładowe sekwencje ruchu AnimationClip to idź ("Walk"), biegnij ("Run"), atakuj ("Attack"), broń ("Defend").
/// Sekwencja AnimationClip wymaga animacji BoneAnimation
/// dla każdej kości.     
///</summary>
struct AnimationClip
{
	float GetClipStartTime()const;
	float GetClipEndTime()const;

    void Interpolate(float t, std::vector<XMFLOAT4X4>& boneTransforms)const;

    std::vector<BoneAnimation> BoneAnimations; 	
};

class SkinnedData
{
public:

	UINT BoneCount()const;

	float GetClipStartTime(const std::string& clipName)const;
	float GetClipEndTime(const std::string& clipName)const;

	void Set(
		std::vector<int>& boneHierarchy, 
		std::vector<XMFLOAT4X4>& boneOffsets,
		std::map<std::string, AnimationClip>& animations);

	 // W prawdziwym projekcie warto rozważyć zapisanie wyników, jeżeli
	 // istnieje szansa, że metoda będzie wywoływana wielokrotnie z tymi
	 // samymi wartościami clipName i timePos.
    void GetFinalTransforms(const std::string& clipName, float timePos, 
		 std::vector<XMFLOAT4X4>& finalTransforms)const;

private:
    // Zwraca indeks rodzica i-tej kości parentIndex.
	std::vector<int> mBoneHierarchy;

	std::vector<XMFLOAT4X4> mBoneOffsets;
   
	std::map<std::string, AnimationClip> mAnimations;
};
 
#endif // SKINNEDDATA_H